
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class DistanceToCapsuleSize: Action
  {
    [Export]
    public Node3D sourceA;

    [Export]
    public Node3D sourceB;

    [Export]
    public CapsuleMesh target;

    [Export]
    public float endRadius = 1;
    [Export]
    public float maxRadius = 1;

    protected override void _OnTrigger()
    {
      if ( sourceA == null || sourceB == null || target == null )
      {
        return;
      }

      var direction = sourceB.GlobalPosition - sourceA.GlobalPosition;
      var distance = direction.Length() + endRadius * 2; 
      target.Height =distance;
      target.Radius = Mathf.Min( distance / 2f, maxRadius );
      
    } 


  }
}