using Godot;
using Rokojori;

[Tool, GlobalClass]
public partial class CollectItem : Action
{
  [Export]
  public Collector collector;

  [Export]
  public PackedScene packedLabel;

  protected override void _OnTrigger()
  {
    var lastItem = collector.lastItemData;

    if ( lastItem == null )
    {
      return;
    }

    var name = lastItem.collectableType.collectableName;

    var collectablesContainer = Unique<GameUI>.Get().collectablesContainer;
    
    var labelRegion = collectablesContainer.CreateChild<UIRegion>( packedLabel );
    
    var label = labelRegion.Get<CollectableLabel>();

    label.text.locale = name;
    label.image.Texture = lastItem.collectableType.collectableIcon;

    
  }
}
