using Godot;
using Rokojori;

[Tool, GlobalClass]
public partial class CollectableCounter : Action
{
  [Export]
  public Collector collector;

  [Export]
  public UIText uiText;

  [Export]
  public CollectableType collectableType;


  int numCollectables = -1;
  int collected = 0;

  public override void _Ready()
  {
    numCollectables = Nodes.AllInScene<Collectable>().Filter( c => c.collectableData.collectableType == collectableType ).Count; 
    uiText.locale = LocaleText.Create( collected + "/" + numCollectables );        
  }

  protected override void _OnTrigger()
  {
    collected ++;

    uiText.locale = LocaleText.Create( collected + "/" + numCollectables );     
  }
}
