using Godot;
using Rokojori;

[Tool, GlobalClass]
public partial class DialogRegion : UIRegion
{
  [Export]
  public UIText dialogText;

  [Export]
  public UIStyle openStyle;

  [Export]
  public UIStyle hiddenStyle;


  public void OpenDialog( LocaleText localeText )
  {    
    dialogText.locale = localeText;
    parentStyle = openStyle;
  }

  public void HideDialog()
  {
    parentStyle.parentStyle = hiddenStyle;
  }


} 