using Godot;
using Rokojori;
using System.Collections.Generic;
using System.Threading.Tasks;

[Tool, GlobalClass]
public partial class PostProcessingHack : Action
{
  [Export]
  public WorldEnvironment environment;

  protected override void _OnTrigger()
  {
    ApplyHack();
  }

  void ApplyHack()
  {
    var godotArray = new Godot.Collections.Array<CompositorEffect>();
    var compositorEffects = environment.Compositor.CompositorEffects;

    for ( int i = 0; i < compositorEffects.Count; i++ )
    {
      if ( compositorEffects[ i ] == null )
      {
        godotArray.Add( null );
        continue;
      }
      godotArray.Add( (CompositorEffect) compositorEffects[ i ].Duplicate() );
    }    

    environment.Compositor.CompositorEffects = godotArray;
  }

  #if TOOLS
  int retriggerFramesCount = 60 * 5;
  int framesCounter = 0;

  public override void _Process( double delta )
  {
    if ( ! Engine.IsEditorHint() )
    {
      return;
    }



    

    framesCounter --;

    if ( framesCounter > 0 )
    {
      return;
    }

    framesCounter = retriggerFramesCount;

    var selection = EditorInterface.Singleton.GetSelection();
    var topSelected = selection.GetTopSelectedNodes();
    
    if ( topSelected.Contains( environment ) )
    {
      // RJLog.Log( "Environment selected, not applying Post Processing Hack" );
      return;
    }    

    // RJLog.Log( "Applying Post Processing Hack" );
    ApplyHack();
    
  }
  #endif
}
