
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Tween.svg")]
  public partial class TweenPixels:SequenceAction, Animator
  {
    // [Export]
    // public PixelationEffect target;

    [Export]
    public WorldEnvironment worldEnvironment;

    [Export]
    public int effectIndex;

    // [Export]
    // public string targetMember;

    [Export]
    public float endValue;

    [Export]
    public Duration duration;

    [Export]
    public Curve curve;

    public void OnAnimatorStart(){}
    public void OnAnimatorEnd(){}
    public void OnAnimatorCancel(){}

    int _actionID = -1;
    int _timeID = -1;

    protected override void _OnTrigger()
    {
      this.LogInfo( "Started Float Tween" );
      

      // if ( Engine.IsEditorHint() )
      // {
      //   return;
      // }

      if ( _actionID != -1 )
      {
        CancelAction( _actionID );
      }

      _actionID = DispatchStart();

      var target = worldEnvironment.Compositor.CompositorEffects[ effectIndex ] as PixelationEffect;

      var startValue = target.pixelSize;
      
      var targetMember = "pixelSize";

    
      AnimationManager.StartAnimation( this, target, targetMember );

      this.LogInfo( "Start Value Float Tween", HierarchyName.OfAny( target ), target.GetType().Name, targetMember, ">>", startValue );

      _timeID = TimeLineManager.ScheduleSpanWith( duration,
        ( span, type )=>
        {         

          // this.LogInfo( "Update Float Tween", startValue );
          if ( span.id != _timeID )
          {
            return;
          }

          if ( ! AnimationManager.IsAnimating( this, target, targetMember ) )
          {
            return;
          }

          var phase = span.phase;

          if ( curve != null )
          {
            phase = curve.Sample( phase );
          }

          var value = Mathf.Lerp( startValue, endValue, phase );

          this.LogInfo( "Updating Float Tween", "phase:", phase, "value:", value, target );

          // ReflectionHelper.SetValue( target, targetMember, value );

          target.pixelSize = value;

          if ( type == TimeLineSpanUpdateType.End )
          {   
            this.LogInfo( "End Float Tween", endValue );  

            // target._Set( targetMember, endValue );     

            target.pixelSize = endValue;
            AnimationManager.EndAnimation( this, target, targetMember );
            DispatchEnd( _actionID );
            _actionID = -1;
            _timeID = -1;
          }
        },

        this
      ).id;
    }

  }
}