
using Godot;


namespace Rokojori
{  
  /** <summary for="class ActionList">
      
      <title>
        Executes multiple actions (Action) at once.
      </title>
      
      <description>
        The ActionList, which is an Action itself, executes all actions stored in the member 'actions' and also child nodes 
        that extend Action, when 'triggerDirectChildren' is checked.

      </description>

    </summary>  
  */
  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/ActionList.svg") ]
  public partial class ActionList : Action
  { 
    
    /** <summary for="field actions">Actions to execute</summary>*/
    [Export]
    public Action[] actions = new Action[ 0 ];

    /** <summary for="field triggerDirectChildren">Whether to execute Action child nodes</summary>*/
    [Export]    
    public bool triggerDirectChildren = true;
    
    protected override void _OnTrigger()
    {
      Action.TriggerAll( actions, this, triggerDirectChildren );
    }
  }
}