
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass, Icon("res://addons/rokojori_action_library/Icons/ActionReference.svg")]
  public partial class ActionReference : Action
  {
    [Export]
    public Action referencedAction;

    [ExportToolButton( "Set Reference Name" )]
    public Callable setReferencedNameButton => Callable.From(
      ()=>
      { 
        if ( referencedAction == null )
        {
          this.Name = "* (nothing)";
        }
        else
        {
          this.Name = "* " + referencedAction.Name;
        }
      }
    );

    protected override void _OnTrigger()
    {
      Action.Trigger( referencedAction );
    }
  }

}