
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool][GlobalClass]
  public partial class PlayMusic:Action
  {
    [Export]
    public AudioStreamPlayer music;

    [ExportToolButton( "Set Reference Name" )]
    public Callable setReferencedNameButton => Callable.From(
      ()=>
      { 
        if ( music == null )
        {
          this.Name = "Play (nothing)";
        }
        else
        {
          this.Name = "Play " + music.Name;
        }
      }
    );

    [Export]
    public bool stopSiblingPlayers = false;
    
    protected override void _OnTrigger()
    {
      if ( stopSiblingPlayers )
      {
        music.GetParent().ForEachDirectChild<AudioStreamPlayer>(
          ( p )=>
          {
            if ( p == music )
            {
              return;
            }

            p.Stop();
          }
        );
      }

      music.Play();
    }
  }
}