
using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/ConditionalAction.svg")]
  public partial class ConditionalAction : Action
  {
    [ExportGroup("Condition")]
    [Export]
    public Condition condition;

    [Export]
    public SceneCondition sceneCondition;

    [ExportGroup("Actions")]
    [Export]
    public Action ifAction;

    [Export]
    public Action elseAction;

    protected override void _OnTrigger()
    {
      var conditionActive = Condition.Evaluate( condition ) || SceneCondition.Evaluate( sceneCondition );

      // this.LogInfo( "Condition is", conditionActive );

      if ( conditionActive )
      {
        Trigger( ifAction );
      }
      else
      {
        Trigger( elseAction );
      }
    }


  }

}