
using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/ConditionalAction.svg")]
  public partial class CoolDown : Action
  {
    [Export]
    public Action action;

    [Export]
    public Duration coolDownDuration;

    bool _isCoolingDown = false;
    int _coolDownID = -1;

    public void RegisterCoolDown()
    {
      _isCoolingDown = coolDownDuration !=  null;

      var te = TimeLineManager.ScheduleEventIn(
          coolDownDuration.timeLine, 
          coolDownDuration.GetDurationInSeconds(),
          ev => 
          {
            if ( _coolDownID != ev.id )
            {
              return;
            }

            _isCoolingDown = false;
          }
        );

      _coolDownID = te.id;
    }

    public void ResetCoolDown()
    {
      if ( _coolDownID == -1 )
      {
        return;
      }

      _isCoolingDown = false;
      _coolDownID = -1;
    }

    protected override void _OnTrigger()
    {
      if ( _isCoolingDown )
      {
        return;
      }

      
      Trigger( action );
      RegisterCoolDown();

    }
  }
}