
using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/GDScriptAction.svg")]
  public partial class GDScriptAction : Action
  {
    public static string onTriggerFunctionName = "_onTrigger";
    public static string rjAction_className = "RJ_Action";

    public static bool IsRJAction( Node n )
    {
      var extractedClass = GDScriptNames.ExtractClassName( n );

      if ( extractedClass == null )
      {
        return false;
      }

      return GDScriptNames.IsOrExtendsFrom( n, rjAction_className );
    }

    public static void TriggerRJAction( Node n, Action caller )
    {
      n.Call( onTriggerFunctionName, caller );
    }

    protected override void _OnTrigger()
    {
      var firstChild = GetChild( 0 );

      if ( firstChild == null || ! IsRJAction( firstChild ) )
      {
        return;
      }

      TriggerRJAction( firstChild, this );
    }

    public async void WrapRJAction( Node rjAction )
    {
      await this.RequestNextFrame();

      if ( rjAction == null || rjAction.GetParent() == null )
      {
        return;
      }

      this.LogInfo( "Wrapping:", rjAction );

      this.Wrap( rjAction );

      this.Name = rjAction.Name + " Wrapper" ;
    }
  }
}