
using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/GDScriptSequenceAction.svg")]
  public partial class GDScriptSequenceAction : SequenceAction
  {
    public static string rjSequenceAction_className = "RJ_SequenceAction";

    public static bool IsRJSequenceAction( Node n )
    {
      var extractedClass = GDScriptNames.ExtractClassName( n );

      if ( extractedClass == null )
      {
        return false;
      }

      return GDScriptNames.IsOrExtendsFrom( n, rjSequenceAction_className );
    }

    public static void TriggerRJ_SequenceAction( Node n, Action caller )
    {
      n.Call( GDScriptAction.onTriggerFunctionName, caller );
    }

    protected override void _OnTrigger()
    {
      var firstChild = GetChild( 0 );

      if ( firstChild == null || ! IsRJSequenceAction( firstChild ) )
      {
        return;
      }

      TriggerRJ_SequenceAction( firstChild, this );
    }

    public async void WrapRJSequenceAction( Node rjSequenceAction )
    {
      await this.RequestNextFrame();

      if ( rjSequenceAction == null || rjSequenceAction.GetParent() == null )
      {
        return;
      }

      this.LogInfo( "Wrapping:", rjSequenceAction );

      this.Wrap( rjSequenceAction );

      this.Name = rjSequenceAction.Name + " Wrapper" ;
    }
  }
}