
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class IterateActions : Action
  {
    [ExportGroup( "Read Only")]
    [Export]
    public int iterationIndex = 0;
  
    protected override void _OnTrigger()
    {
      var num = this.NumDirectChildrenOf<Action>();
      
      if ( num == 0 )
      {
        iterationIndex = 0;
        return;
      }

      iterationIndex = MathX.Repeat( iterationIndex, num );

      Action.Trigger( this.GetNthDirectChild<Action>( iterationIndex ) );

      iterationIndex++;
    }
  }
}