
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass, Icon("res://addons/rokojori_action_library/Icons/SetNodeState.svg")]
  public partial class SetNodeState : Action
  {
    [Export]
    public Node[] enable = new Node[ 0 ];

    [Export]
    public Node[] disable = new Node[ 0 ];

    protected override void _OnTrigger()
    {
      CallDeferred( "SetStates" );
    }

    void SetStates()
    {
      Arrays.ForEach( enable,  n => NodeState.Enable( n ) );
      Arrays.ForEach( disable, n => NodeState.Disable( n ) );
    }
  }

}