
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class CopyMousePosition : Action
  {
    [Export]
    public Camera3D camera;

    [Export]
    public float depth;
  	
    [Export]
    public Node3D target;
    

    protected override void _OnTrigger()
    {
      if ( camera == null || target == null )
      {
        return;
      }

      var mousePosition = GetViewport().GetMousePosition();
      target.GlobalPosition = camera.ProjectPosition( mousePosition, depth );
    }
  }
}