
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class CopyPose : Action
  {
    [Export]
    public Node3D source;

    [Export]
    public Node3D target;

    [Export]
    public bool global = true;


    protected override void _OnTrigger()
    {
      if ( source == null || target == null )
      {
        return;
      }
      
      if ( global )
      {
        target.GlobalPosition = source.GlobalPosition;
        target.GlobalRotation = source.GlobalRotation;
      }
      else
      {
        target.Position = source.Position;
        target.Rotation = source.Rotation;
      }
      
    }
  }
}