
using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool ]
  public partial class CopyPosition : Action
  {
    [Export]
    public Node3D source;

    [Export]
    public Node3D target;

    [Export]
    public Vector3 offset = Vector3.Zero;

    [Export]
    public bool global = true;


    protected override void _OnTrigger()
    {
      if ( source == null || target == null )
      {
        return;
      } 

     
      
      if ( global )
      { 
        target.GlobalPosition = source.GlobalPosition + offset;
      }
      else
      {
        target.Position = source.Position + offset;
      }
    }
  }
}