
using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool ]
  public partial class CopyPositionXZ : Action
  {
    [Export]
    public Node3D source;

    [Export]
    public Node3D target;

    [Export]
    public Vector3 offset = Vector3.Zero;

    [Export]
    public bool global = true;

    protected override void _OnTrigger()
    {
      if ( source == null || target == null )
      {
        return;
      }       
      
      if ( global )
      { 
        var y = target.GlobalPosition.Y;
        var position = source.GlobalPosition + offset;
        position.Y = y;
        target.GlobalPosition = position;
      }
      else
      {
        var y = target.Position.Y;
        var position = source.Position + offset;
        position.Y = y;

        target.Position = position;
      }

     
    }
  }
}