
using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool ]
  public partial class CopyRotation : Action
  {
    [Export]
    public Node3D source;

    [Export]
    public Node3D target;

    [Export]
    public bool global = true;


    protected override void _OnTrigger()
    {
      if ( source == null || target == null )
      {
        return;
      }


      if ( global )
      { 
        target.GlobalRotation = source.GlobalRotation;
      }
      else
      {
        target.Rotation = source.Rotation;
      }
      
    }
  }
}