
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class CopyYawFromDirection : Action
  {
    [Export]
    public Node3D sourceA;

    [Export]
    public Node3D sourceB;

    [Export]
    public Node3D target;

    protected override void _OnTrigger()
    {
      if ( sourceA == null || sourceB == null || target == null )
      {
        return;
      }

      var direction = sourceB.GlobalPosition - sourceA.GlobalPosition;
      var yaw = Math3D.GlobalYaw( direction );
      target.SetGlobalYaw( yaw );
      
    } 


  }
}