
using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool ]
  public partial class DistributeChildren : Action
  {
    [Export]
    public Node3D target;

    [Export]
    public Node3D start;

    [Export]
    public Node3D end;


    protected override void _OnTrigger()
    {
      if ( start == null || end == null || target == null )
      {
        return;
      }
      
      var children = Nodes.GetDirectChildren<Node3D>( target );

      var startPosition = start.GlobalPosition;
      var endPosition   = end.GlobalPosition;

      for ( int i = 0; i < children.Count; i++ )
      {
        var lerpState = i / ( children.Count - 1f );
        var childPosition = startPosition.Lerp( endPosition, lerpState );

        children[ i ].GlobalPosition = childPosition;
      }

      
    }
  }
}