using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class LerpPosition : Action
  {
    [Export]
    public Node3D sourceA;

    [Export]
    public Node3D sourceB;

    [Export]
    public float lerp;

    [Export]
    public Node3D target;

    protected override void _OnTrigger()
    {
      if ( sourceA == null || sourceB == null || target == null )
      {
        return;
      }
      
      target.GlobalPosition = sourceA.GlobalPosition.Lerp( sourceB.GlobalPosition, lerp );
    }
  }
}