using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool ]
  public partial class LookAt : Action
  {
    [Export]
    public Node3D lookFrom;

    [Export]
    public Node3D lookTarget;
    

    protected override void _OnTrigger()
    {
      if ( lookFrom == null || lookTarget == null )
      {
        return;
      }
      
      lookFrom.LookAt( lookTarget.GlobalPosition );
    }
  }
}