using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class MoveTowards:Node
  {
    [Export]
    public Node3D target;

    [Export]
    public Node3D goal;

    [Export]
    public float speed = 5f;

    [Export]
    public Smoothing rotationSmoothing;

    [Export]
    public float yDirectionMultiply = 1;

    public override void _Process( double delta )
    {
       if ( Engine.IsEditorHint() )
      {
        return;
      }

      if ( goal == null )
      {
        return;
      }

      var direction = goal.GlobalPosition - target.GlobalPosition;
      direction.Y *= yDirectionMultiply;

      direction = direction.Normalized() * speed * (float)delta;

      target.GlobalPosition += direction; 

      // this.LogInfo( "Moving:", direction );

      target.LookAt( goal.GlobalPosition );
      var nextRotation = target.GlobalQuaternion();
      var rotation = Smoothing.Apply( rotationSmoothing, nextRotation, (float) delta );
      target.SetGlobalQuaternion( rotation );
    }
  }
}