
using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool ]
  public partial class SetTransform : Action
  {
    [Export]
    public Node3D target;

    public enum IgnoreGlobalLocal
    {
      Ignore, Global, Local
    }

    [ExportGroup( "Position" ) ]
    [Export]
    public IgnoreGlobalLocal positionMode = IgnoreGlobalLocal.Ignore;

    [Export]
    public Vector3 position = Vector3.Zero;

    [ExportGroup( "Rotation" ) ]
    [Export]
    public IgnoreGlobalLocal rotationMode = IgnoreGlobalLocal.Ignore;   

    [Export]
    public Vector3 rotation = Vector3.Zero;

    public enum IgnoreLocal
    {
      Ignore, Local
    }


    [ExportGroup( "Scale" ) ]
    [Export]
    public IgnoreLocal scaleMode = IgnoreLocal.Ignore;

    [Export]
    public Vector3 scale = Vector3.One;

    


    protected override void _OnTrigger()
    {
      if ( target == null )
      {
        return;
      }

      if ( positionMode != IgnoreGlobalLocal.Ignore )
      {
        target.SetLocalOrGlobalPosition( position, positionMode == IgnoreGlobalLocal.Global );
      } 

      if ( rotationMode != IgnoreGlobalLocal.Ignore )
      {
        target.SetLocalOrGlobalRotation( rotation, rotationMode == IgnoreGlobalLocal.Global );
      } 

      if ( scaleMode != IgnoreLocal.Ignore )
      {
        target.Scale = scale;
      } 
      
    }
  }
}