
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass, Icon("res://addons/rokojori_action_library/Icons/OnEvent.svg") ]
  public partial class OnPhysicsProcess : Node
  {
    /** <summary for="field actions">Actions to execute</summary>*/
    [Export]
    public Action[] actions = new Action[ 0 ];

    /** <summary for="field triggerDirectChildren">Whether to execute Action child nodes</summary>*/
    [Export]    
    public bool triggerDirectChildren = true;

    public override void _PhysicsProcess( double delta )
    {     
      Action.TriggerAll( actions, this, triggerDirectChildren );
    }
  }
}