
using Godot;


namespace Rokojori
{  
  [GlobalClass, Tool, Icon("res://addons/rokojori_action_library/Icons/OnEvent.svg") ]
  public partial class OnProcess : Node
  {
    /** <summary for="field actions">Actions to execute</summary>*/
    [Export]
    public Action[] actions = new Action[ 0 ];

    /** <summary for="field triggerDirectChildren">Whether to execute Action child nodes</summary>*/
    [Export]    
    public bool triggerDirectChildren = true;
    
    [Export]
    public bool executeInEditor = false;

    public override void _Process( double delta )
    {     
      if ( Engine.IsEditorHint() && ! executeInEditor )
      {
        return;
      }

      Action.TriggerAll( actions, this, triggerDirectChildren );
    }
  }
}