
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass, Icon("res://addons/rokojori_action_library/Icons/OnEvent.svg") ]
  public partial class OnReady : Node
  {
    /** <summary for="field actions">Actions to execute</summary>*/
    [Export]
    public Action[] actions = new Action[ 0 ];

    /** <summary for="field triggerDirectChildren">Whether to execute Action child nodes</summary>*/
    [Export]
    public bool triggerDirectChildren = true;

    [Export]
    public bool triggerInsideEditor = false;

    public override void _Ready()
    {     
      if ( Engine.IsEditorHint() && ! triggerInsideEditor )
      {
        return;
      }

      Action.TriggerAll( actions, this, triggerDirectChildren );
    }
  }
}