using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [GlobalClass,Tool]
  public partial class SetCollisionShape:Action
  {
    [Export]
    public CollisionShape3D shape3D;

    [Export]
    public bool disabled = false;

    protected override void _OnTrigger()
    {
      if ( shape3D == null )
      {
        return;
      }


      CallDeferred( nameof( DisableShape ) );
    }

    void DisableShape()
    {
      shape3D.Disabled = disabled;
    }
  }
}