
using Godot;


namespace Rokojori
{  
  
  public class SequenceActionFinishedEvent
  {
    public int id;
    public bool success;
  }

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/SequenceAction.svg")]
  public abstract partial class SequenceAction : Action
  {  
   

    int _dispatchCounter = 0;

    public int GetLastSequenceActionID()
    {
      return _dispatchCounter;
    }

    public readonly EventSlot<SequenceActionFinishedEvent> onSequenceDone = new EventSlot<SequenceActionFinishedEvent>();

    public int DispatchStart()
    {
      _dispatchCounter ++;
      return _dispatchCounter;
    }

    public void DispatchEnd( int id )
    {
      onSequenceDone.DispatchEvent( new SequenceActionFinishedEvent{ id = id, success = true } );
    }

    public void DispatchCancelled( int id )
    {
      onSequenceDone.DispatchEvent( new SequenceActionFinishedEvent{ id = id, success = false } );
    }

    public virtual void CancelAction( int id )
    {

    }

    public int TriggerSequenceAndGetID()
    {
      var nextID = GetLastSequenceActionID() + 1;

      Trigger();

      return GetLastSequenceActionID() < nextID ? -1 : nextID;
    }

  
  }

}