
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class SetPauseState : Action
  {
    public enum Mode
    {
      Pause,
      Resume,
      Toggle
    }

    [Export]
    public Mode mode;

    [Export]
    public Action onPausing;

    [Export]
    public Action onResuming;

    [Export]
    public bool onlyTriggerOnChange = true;

    protected override void _OnTrigger()
    {
      
      var currentState = GetTree().Paused;

      var nextState = Mode.Toggle == mode ? ! currentState : Mode.Pause == mode ? false : true;

      this.LogInfo( "SetPauseState", currentState, ">>", nextState );

      if ( currentState == nextState && onlyTriggerOnChange )
      {
        return;
      }


      this.LogInfo( "Setting Pause State", nextState );
      GetTree().Paused = nextState;

      if ( nextState )
      {
        Action.Trigger( onPausing );
      }
      else 
      {
        Action.Trigger( onResuming );
      }

    }
  }

}