
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass ]
  public partial class Solo:Action
  {
    [Export]
    public Node soloNode;

    [Export]
    public NodeStateConfiguration soloConfiguration;

    [Export]
    public NodeStateConfiguration muteConifiguration;


    protected override void _OnTrigger()
    {
      var parent = soloNode.GetParent();

      parent.ForEachDirectChild<Node>( 
        n => 
        { 
          var configuration = soloNode == n ? soloConfiguration : muteConifiguration;
          NodeState.Configure( n, configuration );
        }
      );
    }
  }
}