
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Delay.svg")]
  public partial class Delay : SequenceAction
  {
    [Export]
    public float duration; 

    [Export]
    public TimeLine timeLine;
    

    protected override void _OnTrigger()
    {      
      var sequenceID = DispatchStart();

      // this.LogInfo( "time:", Time.GetTicksMsec() / 1000f );
      
      if ( Engine.IsEditorHint() )
      {
        TimeLineManager.ScheduleSpanIn( timeLine, 0, duration , 
          ( span, type )=>
          { 
            if ( type == TimeLineSpanUpdateType.End )
            {
              DispatchEnd( sequenceID ); 
              // this.LogInfo( "time:", Time.GetTicksMsec() / 1000f );
            }
          },
          this 
        );
      }
      else
      {
        var eventID = TimeLineManager.ScheduleEventIn( timeLine, duration, 
          ( tle ) =>
          { 
            DispatchEnd( sequenceID ); 
            
          },
          this
        );
      }
    
    }

    
  }
}