
using Godot;

using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class DelayedList : Action
  {
    [Export]
    public float durationInbetween = 0.1f;

    [Export]
    public float growDuration = 0.0f;

    [Export]
    public TimeLine timeLine;

    [Export]
    public Action[] actions = new Action[ 0 ];

    /** <summary for="field triggerDirectChildren">Whether to execute Action child nodes</summary>*/
    [Export]    
    public bool triggerDirectChildren = true;

    protected override void _OnTrigger()
    {
      var list = new List<Action>();

      list.AddRange( actions );

      if ( triggerDirectChildren )
      {
        list.AddRange( Nodes.GetDirectChildren<Action>( this ) );
      }

      var offset = 0f;
      var grow = 0f;

      for ( int i = 0; i < list.Count; i++ )
      {
        TimeLineManager.ScheduleEventIn( timeLine, offset, 
          id => 
          { 
            Action.Trigger( list[ i ] );
          }        
        );  

        grow += growDuration;
        offset += durationInbetween + grow;     
        
      }      
    }
  }
}