
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class Repeat : Action
  {

    [Export]
    public float duration;
    
    [Export]
    public int numRepeats;

    [Export]
    public TimeLine timeLine;

    [Export]
    public Action action;

    [Export]
    public Action onBeforeFirst;

    [Export]
    public Action onAfterLast;


    protected override void _OnTrigger()
    {
      for ( int i = 0; i < numRepeats; i++ )
      {
        TimeLineManager.ScheduleEventIn( timeLine, i * duration, 
          id => 
          { 
            if ( i == 0 )
            {
              Action.Trigger( onBeforeFirst );
            }

            Action.Trigger( action );

            if ( i == ( numRepeats - 1 ) )
            {
              Action.Trigger( onAfterLast );
            }
          }
        
        );
        
        
      }      
    }
  }
}