
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass ]
  public partial class SetMaterial : Action
  {
    [Export]
    public Node3D target;

    [Export]
    public Material material;

    [Export]
    public MaterialSlot slot = MaterialSlot.None;

    [Export]
    public int index = 0;



    protected override void _OnTrigger()
    {
      if ( target == null  )
      {
        return;
      }

      var msc = MaterialSurfaceContainer.From( target, index );

      if ( material == null )
      {
        msc.RemoveMaterialInSlot( slot );
      }
      else
      {
        msc.SetMaterialInSlot( slot, material );
      }

      

    }
  }
}