
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Tween.svg")]
  public partial class TweenColor:SequenceAction, Animator
  {
    [Export]
    public GodotObject target;

    [Export]
    public string targetMemberPath;

    [Export]
    public Color endValue;

    [Export]
    public Duration duration;

    [Export]
    public Curve curve;

    public void OnAnimatorStart(){}
    public void OnAnimatorEnd(){}
    public void OnAnimatorCancel(){}

    int _actionID = -1;
    int _timeID = -1;


    
    public Color GetTargetValue( GodotObject go, string targetMember, Color alternative )
    {
      var path = targetMember.Split( "/" );
      var prop = path[ path.Length - 1 ];

      var target = ReflectionHelper.GetMemberByPath<object>( go, path, false );

      return target == null ? alternative : ReflectionHelper.GetValue<Color>( target, prop );

    }

    public void SetTargetValue( GodotObject go, string targetMember, Color value )
    {
      var path = targetMember.Split( "/" );
      var prop = path[ path.Length - 1 ];

      var target = ReflectionHelper.GetMemberByPath<object>( go, path, false );

      if ( target == null )
      {
        return;
      }

      ReflectionHelper.SetValue( target, prop, value ); 
    }

    protected override void _OnTrigger()
    {
      this.LogInfo( "Started Float Tween" );
      

      // if ( Engine.IsEditorHint() )
      // {
      //   return;
      // }

      if ( _actionID != -1 )
      {
        CancelAction( _actionID );
      }

      _actionID = DispatchStart();
      
      // var startValue = ReflectionHelper.GetValue<float>( target, targetMember );
      var startValue = GetTargetValue( target, targetMemberPath, Colors.White );
      
      AnimationManager.StartAnimation( this, target, targetMemberPath );

      this.LogInfo( "Start Value Float Tween", HierarchyName.OfAny( target ), target.GetType().Name, targetMemberPath, ">>", startValue );

      _timeID = TimeLineManager.ScheduleSpanWith( duration,
        ( span, type )=>
        {         

          // this.LogInfo( "Update Float Tween", startValue );
          if ( span.id != _timeID )
          {
            return;
          }

          if ( ! AnimationManager.IsAnimating( this, target, targetMemberPath ) )
          {
            return;
          }

          var phase = span.phase;

          if ( curve != null )
          {
            phase = curve.Sample( phase );
          }

          var value = ColorX.Lerp( startValue, endValue, phase );

          // this.LogInfo( "Updating Float Tween", "phase:", phase, "value:", value, target );

          // ReflectionHelper.SetValue( target, targetMember, value );
          // target._Set( targetMember, value );    
          SetTargetValue( target, targetMemberPath, value );

          if ( type == TimeLineSpanUpdateType.End )
          {   
            // this.LogInfo( "End Float Tween", endValue );  

            SetTargetValue( target, targetMemberPath, value );    
            AnimationManager.EndAnimation( this, target, targetMemberPath );
            DispatchEnd( _actionID );
            _actionID = -1;
            _timeID = -1;
          }
        },

        this
      ).id;
    }

  }
}