
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass ]
  public partial class TweenLightData:Resource
  {
    [ExportGroup("Light")]
    [Export]
    public ColorValue lightColor;

    [Export]
    public FloatValue lightEnergy;

    [Export]
    public FloatValue lightSpecular;

    [ExportGroup("Shadow")]
    [Export]
    public FloatValue shadowOpacity;


    public virtual TweenLightData Clone( bool deepClone )
    {
      var clone = new TweenLightData();
      
      clone.lightColor = ColorValue.Clone( lightColor, deepClone );
      clone.lightEnergy = FloatValue.Clone( lightEnergy, deepClone );
      clone.lightSpecular = FloatValue.Clone( lightSpecular, deepClone );

      clone.shadowOpacity = FloatValue.Clone( shadowOpacity, deepClone );
      
      return clone;

    }

    public virtual void CopyFrom( Light3D light3D )
    {
      lightColor = ColorValue.Create( light3D.LightColor );
      lightEnergy = FloatValue.Create( light3D.LightEnergy );
      lightSpecular = FloatValue.Create( light3D.LightSpecular );

      shadowOpacity = FloatValue.Create( light3D.ShadowOpacity );
    }


    public virtual void CopyFrom( TweenLightData tweenLightData )
    {
      lightColor = tweenLightData.lightColor;
      lightEnergy = tweenLightData.lightEnergy;
      lightSpecular = tweenLightData.lightSpecular;

      shadowOpacity = tweenLightData.shadowOpacity;
    }

    public virtual void CopyTo( Light3D light3D )
    { 
      if ( lightColor != null )
      { light3D.LightColor = lightColor.value; }

      if ( lightEnergy != null )
      { light3D.LightEnergy = lightEnergy.value; }

      if ( lightSpecular != null )
      { light3D.LightSpecular = lightSpecular.value; }

      if ( shadowOpacity != null )
      { light3D.ShadowOpacity = shadowOpacity.value; }

    }

    public static void LerpTo( TweenLightData a, TweenLightData b, float lerpAmount, TweenLightData output )
    {
      ColorValue.Lerp( a.lightColor, b.lightColor, lerpAmount, output.lightColor );
      FloatValue.Lerp( a.lightEnergy, b.lightEnergy, lerpAmount, output.lightEnergy );
      FloatValue.Lerp( a.lightSpecular, b.lightSpecular, lerpAmount, output.lightSpecular );

      FloatValue.Lerp( a.shadowOpacity, b.shadowOpacity, lerpAmount, output.shadowOpacity );
    }
    
  }
}