using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass ]
  public partial class TweenParticlesData:Resource
  {
    
    [Export]
    public FloatValue amount;

    [Export]
    public FloatValue amountRatio;

    [ExportGroup("Time")]
    [Export]
    public FloatValue lifeTime;

    [Export]
    public FloatValue speedScale;

    [Export]
    public FloatValue explosiveness;

    [Export]
    public FloatValue randomness;


    public virtual TweenParticlesData Clone( bool deepClone )
    {
      var clone = new TweenParticlesData();
      
      clone.amount = FloatValue.Clone( amount, deepClone );
      clone.amountRatio = FloatValue.Clone( amountRatio, deepClone );
      clone.lifeTime = FloatValue.Clone( lifeTime, deepClone );

      clone.speedScale = FloatValue.Clone( speedScale, deepClone );
      clone.explosiveness = FloatValue.Clone( explosiveness, deepClone );
      clone.randomness = FloatValue.Clone( randomness, deepClone );
      
      return clone;

    }

    public virtual void CopyFrom( GpuParticles3D particles )
    {
      amount = FloatValue.Create( particles.Amount );
      amountRatio = FloatValue.Create( particles.AmountRatio );
      lifeTime = FloatValue.Create( particles.Lifetime );

      speedScale = FloatValue.Create( particles.SpeedScale );
      explosiveness = FloatValue.Create( particles.Explosiveness );
      randomness = FloatValue.Create( particles.Randomness );
    }


    public virtual void CopyFrom( TweenParticlesData tweenLightData )
    {
      amount = tweenLightData.amount;
      amountRatio = tweenLightData.amountRatio;
      lifeTime = tweenLightData.lifeTime;

      speedScale = tweenLightData.speedScale;
      explosiveness = tweenLightData.explosiveness;
      randomness = tweenLightData.randomness;
    }

    public virtual void CopyTo( GpuParticles3D particles )
    { 
      if ( amount != null )
      {
        particles.Amount = Mathf.RoundToInt( amount.value );

      }

      if ( amountRatio != null )
      {
        particles.AmountRatio = amountRatio.value;
        particles.Emitting = amountRatio.value > 0;
      }

      if ( lifeTime != null )
      {
        particles.Lifetime = lifeTime.value;
      }


      if ( speedScale != null )
      {
        particles.SpeedScale = speedScale.value;
      }

      if ( explosiveness != null )
      {
        particles.Explosiveness = explosiveness.value;
      }

      if ( randomness != null )
      {
        particles.Randomness = randomness.value;
      }

    }

    public static void LerpTo( TweenParticlesData a, TweenParticlesData b, float lerpAmount, TweenParticlesData output )
    {
      FloatValue.Lerp( a.amount, b.amount, lerpAmount, output.amount );
      FloatValue.Lerp( a.amountRatio, b.amountRatio, lerpAmount, output.amountRatio );
      FloatValue.Lerp( a.lifeTime, b.lifeTime, lerpAmount, output.lifeTime );

      FloatValue.Lerp( a.speedScale, b.speedScale, lerpAmount, output.speedScale );
      FloatValue.Lerp( a.explosiveness, b.explosiveness, lerpAmount, output.explosiveness );
      FloatValue.Lerp( a.randomness, b.randomness, lerpAmount, output.randomness );
    }
    
  }
}