using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class AnimationCurve:Resource
  { 
    [Export]
    public float duration = 1;

    [Export]
    public float durationRandomRange = 0;
    
    [Export]
    public float delay = 0;

    [Export]
    public float delayRandomRange = 0;


    [Export]
    public Curve curve = MathX.Curve( 0, 0, -1, 1 );
    
    [Export]
    public float scaleY = 1;

    [Export]
    public float scaleRandomRange = 0;

    public float GetRandomizedDuration( Vector3 random )
    {
      return duration + random.X;
    }

    public float GetRandomizedDelay( Vector3 random )
    {
      return delay + random.Y;
    }

    public float GetRandomizedEndTime( Vector3 random )
    {
      return GetRandomizedDuration( random ) + GetRandomizedDelay( random );
    }

    public float GetRandomizedScale( Vector3 random )
    {
      return scaleY + random.Z;
    }

    public Vector3 Randomize( RandomEngine random = null )
    {
      random = random == null ? GodotRandom.Get() : random;

      return new Vector3( 
        random.Polar() * durationRandomRange,  
        random.Polar() * delayRandomRange,  
        random.Polar() * scaleRandomRange
      );

    }
    
    public float Sample( float time, float durationOffset = 0, float delayOffset = 0, float scaleOffset = 0 )
    {
      time -= Mathf.Max( 0f, delay + delayOffset );
      var phase = MathX.Clamp01( time / ( Mathf.Max( 0.001f, duration + durationOffset ) ) );
      
      return curve.Sample( phase ) * ( scaleY + scaleOffset );
    }

    public float Sample( float time, Vector3 randomization )
    {
      return Sample( time, randomization.X, randomization.Y, randomization.Z );
    }
  }
  
}