using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class FlashEffect:Resource
  {    

    [ExportGroup( "Flash")]
    [Export]
    public AnimationCurve flashCurve;

    [Export]
    public TimeLine timeline;


    [Export]
    public HDRColor color;

    public enum FlashLightMode
    {
      No_Light,
      Origin_Of_First,
      Center_Of_All
    }

    [ExportGroup( "Flash/Light")]    

    [Export]
    public FlashLightMode lightMode;

    [Export]
    public float lightRange = 2;

    [Export]
    public float lightFlashCurveScale = 2;

    [Export]
    public bool lightHasShadows = false;


    public enum MaterialMode
    {
      Flat_Standard3D,
      Fresnel_FresnelOverlay,
      Scan_ScanGradient,
      Shield_TriPlanarOverlay,
      Custom_Material
    }

    [ExportGroup( "Material")]
    

    [Export]
    public MaterialMode materialMode;

    [Export]
    public Material customMaterial;

    [Export]
    public ColorPropertyName customFlashColorProperty;

   

  

  }
}