using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class Follow:Node
  { 
    [Export]
    public Node3D source;
    
    [Export]
    public Node3D target;

    [Export]
    public Smoothing positionSmoothing;

    [Export]
    public TimeLine timeline;

    float _lastCoefficient = 0;
    int _lastFrames = -1;

    public override void _Process( double delta )
    {
      /*if ( positionSmoothing != null && positionSmoothing is ExpSmoothing exp )
      {
        if ( _lastCoefficient != exp.coefficient )
        { 
          _lastCoefficient = exp.coefficient;
          
          var duration = exp.ComputeDuration();

          var framesOn60hz = duration / ( 1f / 60f ); 

          this.LogInfo( "Duration:", duration._FFF(), "seconds or", framesOn60hz._FF(), "frames", "For coefficient:", _lastCoefficient );
        }
      }

      if ( positionSmoothing != null && positionSmoothing is FrameSmoothing fra )
      {

        if ( _lastFrames != fra.frames )
        { 
          _lastFrames = fra.frames;
          
          var coefficient = FrameSmoothing.GetCoefficientForFrames( fra.frames );

          var framesOn60hz = fra.frames * ( 1f / 60f ); 

          this.LogInfo( "Frames:", fra.frames, "Seconds", framesOn60hz._FF(), "Coefficient:", coefficient );
        }
      }

      */

      if ( source == null || target == null || Engine.IsEditorHint() )
      {
        return;
      }

      var tl = TimeLineManager.Ensure( timeline );
      target.GlobalPosition = Smoothing.Apply( positionSmoothing, source.GlobalPosition, tl.delta );
    }
  }
}