using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class HDRColor:Resource
  { 
    [Export]
    public Color color;

    [Export]
    public float colorMultiply = 1;

    [Export]
    public float rgbMultiply = 1;

    [Export]
    public float alphaMultiply = 1;

    public Color GetHDRColor()
    {
      var v4 = ColorX.ToVector4( color ) * colorMultiply;

      v4.X *= rgbMultiply;
      v4.Y *= rgbMultiply;
      v4.Z *= rgbMultiply;
      v4.W *= alphaMultiply;

      return ColorX.FromVector4( v4 );
    }

  }
}