using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  
  [Tool]
  [GlobalClass]
  public partial class SetPointableHighlightEffect:Action
  {
    [Export]
    public Pointable pointable;

    [Export]
    public HighlightEffect effect;

    [Export]
    public bool startHighlight = false;


    protected override void _OnTrigger()
    {
      this.LogInfo( "Change Hightlight", HierarchyName.Of( effect ) );
      pointable.highlightEffect = effect;

      if ( effect != null && startHighlight )
      {
        HighlightEffect.CancelHighlight( pointable.highlightTargets );
        effect.Highlight( HighlightActionType.Start, [ pointable ] );
      }
    }
  }
}