using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class MoveLoop:Node3D
  { 
    [Export]
    public Curve x;

    [Export]
    public Curve y;

    [Export]
    public Curve z;

    [Export]
    public Node3D target;

    [Export]
    public Duration duration;

    [Export]
    public bool global = false;

    public override void _Process( double delta )
    {
      if ( target == null || duration == null )
      {
        return;
      }

      var phase = duration.GetLoopPhase();
      
      var position = target.GetLocalOrGlobalPosition( global );

      if ( x != null )
      {
        position.X = x.Sample( phase );
      }

      if ( y != null )
      {
        position.Y = y.Sample( phase );
      }

      if ( z != null )
      {
        position.Z = z.Sample( phase );
      }

      target.SetLocalOrGlobalPosition( position, global );


    

    }
  }

}