using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class Rotate:Node3D
  { 
    [Export]
    public Vector3 eulerRotation;

    [Export]
    public Node3D target;

    [Export]
    public TimeLine timeline;

    public override void _Process( double delta )
    {
      if ( target == null )
      {
        return;
      }

      var tl = TimeLineManager.Ensure( timeline );
      var rotation = target.GlobalQuaternion() * Quaternion.FromEuler( eulerRotation * (float)tl.delta );
      target.SetGlobalQuaternion( rotation );
    }
  }

}