using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class ShakeEffect:Resource
  {    
    
    [Export]
    public AnimationCurve shakeAmountCurve;

    [Export]
    public AnimationCurve shakeChangeFPSCurve;

    [Export]
    public AnimationCurve shakeChangeFPSRandomCurve;
    
    [Export]
    public TimeLine timeline;

    [Export]
    public bool smooth = true;

    [Export( PropertyHint.Range, "0,1" )]
    public float smoothingStrength = 0;

    public float GetShakeChangeFPSRandomized( float time, RandomEngine random = null )
    {
      random = RandomEngine.CreateIfNull( random );
      var staticChange = shakeChangeFPSCurve == null ? 60 : shakeChangeFPSCurve.Sample( time );
      var randomChange = shakeChangeFPSRandomCurve == null ? 0 : shakeChangeFPSRandomCurve.Sample( time );
      return staticChange + random.Polar( randomChange );
    }

    [Export]
    public Vector3 positionShake = Vector3.Zero;
    [Export]
    public bool globalPosition = true;
    [Export]
    public bool repeatAndFlipFirstPosition = true;

    [Export]
    public Vector3 rotationShake = Vector3.Zero;
    [Export]
    public bool globalRotation = true;

    [Export]
    public Vector3 scaleShake = Vector3.Zero;

    [Export]
    public bool scaleShakeIsRelative = true;

    public TransformData GetShakeData( float time, Vector3 curveRandomization, RandomEngine random = null )
    {
      random = RandomEngine.CreateIfNull( random );

      var shakeAmount = shakeAmountCurve.Sample( time, curveRandomization );

      var transformData = new TransformData();
      transformData.position = random.IndividualBetween( -positionShake, positionShake ) * shakeAmount;
      transformData.rotation = random.IndividualBetween( -rotationShake, rotationShake ) * shakeAmount;
      transformData.scale    = random.IndividualBetween( -scaleShake, scaleShake ) * shakeAmount;

      return transformData;

    } 

       

  }
}