using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class SkyAnimator:Node
  {     
    [Export]
    public Camera3D camera;

    [Export]
    public WorldEnvironment environment;

    [Export]
    public float minFov = 60;

    [Export]
    public float maxFov = 60;

    [Export]
    public float minFovCameraY = 10;

    [Export]
    public float maxFovCameraY = 200;

    [Export]
    public float maxRotationX = 10;

    [Export]
    public float cameraToRotationX = 100; 

    [Export]
    public float maxRotationZ = 10;

    [Export]
    public float cameraToRotationZ = 100; 



    public override void _Process( double delta )
    {      
      var fov = MathX.MapClamped( camera.GlobalPosition.Y, minFovCameraY, maxFovCameraY, minFov, maxFov );
      environment.Environment.SkyCustomFov = fov;


      if ( ! Engine.IsEditorHint() )
      {
        // this.LogInfo( "FOV:", camera.GlobalPosition.Y + "m" , fov );
      }

      // var rotX = MathX.MapClamped( camera.GlobalPosition.X, -cameraToRotationX, cameraToRotationX, -maxRotationX, maxRotationX ); 
      // environment.Environment.SkyRotation = new Vector3( rotX, 0, 0 );
      
    }
  }
}