using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
	public partial class ExpSmoothing: Smoothing
	{
    [Export( PropertyHint.Range, "0,200")]
    public float coefficient = 1;      
    
    protected override float _ComputeInterpolationAmount( float delta )
    {
      return 1f - Mathf.Exp( -coefficient * delta );
    }

    public static float GetDurationForCoefficient( float coefficient )
    {
      var exp = new ExpSmoothing();
      exp.coefficient = coefficient;
      return exp.ComputeDuration();
    }


    public static float ComputeCoefficientForFramesAdaptiveTreshold( int numFrames )
    {  
      var fps60 = 1f/60f; 
      var treshold = MathX.MapClamped( numFrames, 400, 600, fps60/50, fps60/2 );

      return ComputeCoefficientForFrames( numFrames, treshold );


    }

    public static float ComputeCoefficientForFrames( int numFrames, float treshold = 1f/60f * 0.02f )
    {      

      var lowDurationCoefficient  = 500f;
      var highDurationCoefficient = 0.1f;

      if ( numFrames < 1 )
      {
        return lowDurationCoefficient;
      }

      var framesDuration = numFrames * 1/60f;


      var minMaxSearch = new MinMaxSearch<float>(
        ( a, b, t ) => Mathf.Lerp( a, b, t ),
        ( c ) => ExpSmoothing.GetDurationForCoefficient( c )
      );      
      
      var coefficient = minMaxSearch.Find( framesDuration, lowDurationCoefficient, highDurationCoefficient, treshold );
    

      return coefficient;

    }
  }
}